<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBExperience 3.7                                                 # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2006-2008 Marius Czyz. All Rights Reserved.             ||
|| #################################################################### ||
\*======================================================================*/


// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'forum', 'user', 'cpglobal');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_stats.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}
 
// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['xperience_name']);


$vbulletin->input->clean_array_gpc('r', array(
	'do' => TYPE_STR,
	'id' => TYPE_INT));

	$members = $vbulletin->db->query_first("
			SELECT
			COUNT(*) AS users
			FROM " . TABLE_PREFIX . "user as u 
		"); 
	$userscount=$members['users'];
	


	$current_timestamp=mktime(date("H"), date("i"), 0, date("m"), date("d"), date("Y"));

 if ($vbulletin->GPC['do'] == 'mancpoints') {
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_mancpoints'], 1);

	$pointsq =$vbulletin->db->query_read("SELECT
		user.username, c.*
		FROM " . TABLE_PREFIX . "xperience_custompoints as c
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (c.userid = user.userid)
		ORDER BY dateline
		");
		
		

	
		
		if ($vbulletin->db->num_rows($pointsq)>0){
			while ($points = $vbulletin->db->fetch_array($pointsq)) {
				print_description_row('<a href="xperience_admin.php?do=editpoints&id='.$points['pointid'].'">'.vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $points['dateline']).', '.$points['username'].'</a><dfn>: '.$points['points_misc_custom'].', '.$points['comment'].'</dfn>');
			}
		} else {
				print_description_row($vbphrase['xperience_admin_no_custom_points']);
		}
		print_table_footer(1);

	print_form_header('');
	print_table_header('Add Points', 1);
	print_description_row('<a href="xperience_admin.php?do=addpoints">'.$vbphrase[xperience_admin_add_custom_points].'</a>');		
	print_table_footer(1);
}
 if ($vbulletin->GPC['do'] == 'addpoints') {

	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_custompoints (adminid, dateline) VALUES (".$vbulletin->userinfo['userid'].", ".$current_timestamp.")");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=editpoints&id='.$vbulletin->db->insert_id(), 0);

}
 
 if ($vbulletin->GPC['do'] == 'editpoints') {
	print_form_header('xperience_admin', 'savepoints');
	print_table_header($vbphrase['xperience_admin_edit_custom_points'], 2, 0);
	
	$pointsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_custompoints WHERE pointid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($pointsq)>0){
			$points = $vbulletin->db->fetch_array($pointsq);
			
			
			print_input_row($vbphrase['userid'], 'userid', $points['userid']);	
			print_input_row($vbphrase['xperience_admin_custom_points_neg'], 'points_misc_custom', $points['points_misc_custom']);	
			print_input_row($vbphrase['comment'], 'comment', $points['comment']);	
			print_checkbox_row($vbphrase['xperience_admin_delete_custom_points'], 'delpoints', false, 1);
			echo "<input type=\"hidden\" name=\"pointid\" value=\"" . $points['pointid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}
 
 
 if ($vbulletin->GPC['do'] == 'savepoints') {

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_INT,
		'points_misc_custom' => TYPE_INT,
		'comment' => TYPE_STR,
		'delpoints' => TYPE_INT,
		'pointid' => TYPE_INT
	));

	if ($vbulletin->GPC['delpoints'] ==1) {
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_custompoints WHERE pointid=".$vbulletin->GPC['pointid']);
	} else {
		
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_custompoints SET
		userid=".$vbulletin->GPC['userid'].",
		points_misc_custom=".$vbulletin->GPC['points_misc_custom'].",
		comment='".$vbulletin->GPC['comment']."'
		WHERE pointid=".$vbulletin->GPC['pointid']);
	}
	
	print_done("xperience_admin.php?do=mancpoints");
}
 
 

if ($vbulletin->GPC['do'] == 'delstats') {
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_delete_stats'], 3);
	print_description_row('<a href="xperience_admin.php?do=dodelstats"">'.$vbphrase[xperience_admin_delete_confirm].'</a>');
	print_table_footer(1);
}

if ($vbulletin->GPC['do'] == 'dodelstats') {
	
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_stats");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user 
		SET
		xperience_done=1, 
		xperience=0,
		xperience_level=0,
		xperience_next_level=0,
		xperience_next_level_points=0,
		xperience_ppd=0");
		
	print_done();
}

if ($vbulletin->GPC['do'] == 'genawards') {
	
	require_once(DIR . '/includes/class_xperience.php');
	$xPerience =& new xPerience;
	$xPerience->CalculateAwards();
	print_done("xperience_admin.php?do=manawards");
}

if ($vbulletin->GPC['do'] == 'manawards') {
	print_form_header('');
	print_table_header($vbphrase['xperience_admin_manawards'], 1);

	$awardsq =$vbulletin->db->query_read("SELECT
		*
		FROM " . TABLE_PREFIX . "xperience_awards
		ORDER BY awardstatus
		");
		
	if ($vbulletin->db->num_rows($awardsq)>0){
		while ($awards = $vbulletin->db->fetch_array($awardsq)) {
			print_description_row($awards['awardstatus'].' <a href="xperience_admin.php?do=editaward&id='.$awards['awardid'].'">'.$awards['awardtitle'].'</a><dfn>'.$awards['awarddesc'].'</dfn>');
		}
	} else {
			print_description_row($vbphrase['xperience_admin_awards_none']);
	}
	print_table_footer(1);

	print_form_header('');
	print_table_header($vbphrase['xperience_awards'], 1);
	print_description_row('<a href="xperience_admin.php?do=addaward">'.$vbphrase[xperience_admin_awards_add].'</a>');
	print_description_row('<a href="xperience_admin.php?do=genawards">'.$vbphrase[xperience_admin_awards_gen].'</a>');
	print_table_footer(1);
}


if ($vbulletin->GPC['do'] == 'addaward') {
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "xperience_awards (awardtitle, awarddesc, awardstatus) VALUES ('New Award', 'Great Award!', 0)");
	print_cp_message('Redirecting...', 'xperience_admin.php?do=editaward&id='.$vbulletin->db->insert_id(), 0);

}


if ($vbulletin->GPC['do'] == 'editaward') {
	print_form_header('xperience_admin', 'saveaward');
	print_table_header($vbphrase['xperience_admin_awards_edit'], 2, 0);
	
	$awardsq =$vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "xperience_awards WHERE awardid=".$vbulletin->GPC['id']);
		
		if ($vbulletin->db->num_rows($awardsq)>0){
			$awards = $vbulletin->db->fetch_array($awardsq);
			
			print_input_row($vbphrase['xperience_admin_awards_id'], 'awardname', $awards['awardname']);	
			print_input_row($vbphrase['title'], 'awardtitle', $awards['awardtitle']);	
			print_input_row($vbphrase['description'], 'awarddesc', $awards['awarddesc']);
			print_input_row($vbphrase['xperience_admin_awards_manualassign'], 'manualassign', $awards['manualassign']);
			print_input_row($vbphrase['xperience_admin_awards_limit'], 'awardlimit', $awards['awardlimit']);
			print_input_row("$vbphrase[display_order]<dfn>$vbphrase[zero_equals_no_display]</dfn>", 'awardstatus', $awards['awardstatus']);
			
			$fields = array();
			$sel_fields = array();
			$optionsq =$vbulletin->db->query_read("SHOW COLUMNS
			FROM " . TABLE_PREFIX . "xperience_stats LIKE 'points_%'");
					
			if ($vbulletin->db->num_rows($optionsq)>0){
				while ($options = $vbulletin->db->fetch_array($optionsq)) {
					//if () {
						$fields["$options[Field]"]=$options['Field'];
				//	}
				}
			}
			//sort($fields, SORT_STRING);
			$sel_fields=explode("+", $awards['awardfields']);
			print_select_row($vbphrase['xperience_admin_awards_sum'], "awardfields[]", $fields, $sel_fields, false, $size = 30, $multiple = true);
			
			//TODO
			//print_input_row('Exclude Usergroups<dfn>These usergroups cannot get this award. Seperate them by a colon, e.g. 16,65,71</dfn>', 'awardexclusions', $awards['awardexclusions']);	
			
			print_checkbox_row($vbphrase['xperience_admin_awards_del'], 'delaward', false, 1);
			echo "<input type=\"hidden\" name=\"awardid\" value=\"" . $awards['awardid'] . "\" />\n";
			print_submit_row($vbphrase['save']);
	}

}


if ($vbulletin->GPC['do'] == 'saveaward') {

	$vbulletin->input->clean_array_gpc('r', array(
		'awardname' => TYPE_STR,
		'awardtitle' => TYPE_STR,
		'awarddesc' => TYPE_STR,
		'awardstatus' => TYPE_INT,
		'awardlimit' => TYPE_INT,
		'awardexclusions' => TYPE_STR,
		'awardid' => TYPE_UINT,
		'manualassign' => TYPE_UINT,
		'delaward' => TYPE_UINT,
		'awardfields' => TYPE_ARRAY
	));



	if ($vbulletin->GPC['delaward'] ==1) {
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "xperience_awards WHERE awardid=".$vbulletin->GPC['awardid']);
	} else {
		
		$awardfields_str = implode("+", $vbulletin->GPC['awardfields']);
		if (strlen($awardfields_str)<2) $awardfields_str="+points_user";
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "xperience_awards SET
		awardname='".addslashes($vbulletin->GPC['awardname'])."',
		awardtitle='".addslashes($vbulletin->GPC['awardtitle'])."',
		awarddesc='".addslashes($vbulletin->GPC['awarddesc'])."',
		awardstatus=".$vbulletin->GPC['awardstatus'].",
		awardlimit=".$vbulletin->GPC['awardlimit'].",
		manualassign=".$vbulletin->GPC['manualassign'].",
		awardexclusions='".addslashes($vbulletin->GPC['awardexclusions'])."',
		awardfields='".addslashes($awardfields_str)."'
		WHERE awardid=".$vbulletin->GPC['awardid']);
	}
	
	print_done("xperience_admin.php?do=manawards");
}



if ($vbulletin->GPC['do'] == 'stats') {

	// we'll need a poll image
	$style = $db->query_first("
		SELECT stylevars FROM " . TABLE_PREFIX . "style
		WHERE styleid = " . $vbulletin->options['styleid'] . "
		LIMIT 1
	");
	$stylevars = unserialize($style['stylevars']);
	unset($style);


	print_form_header('');
	print_table_header($vbphrase['xperience_admin_level_stats'], 3);
	print_cells_row(array($vbphrase['xperience_admin_level_level'], $vbphrase['xperience_admin_level_percent'], $vbphrase['xperience_admin_level_count']), 1);
        
	$levels = $vbulletin->db->query_read("SELECT
		xperience_level, COUNT(*) as levelcount
		FROM " . TABLE_PREFIX . "user
		GROUP BY xperience_level");
	
	while ($level = $vbulletin->db->fetch_array($levels)) { 
		$i++;
		$bar = ($i % 6) + 1; 
		print_statistic_result($level['xperience_level'], $bar, $level['levelcount'], ceil(($level['levelcount']/$userscount) * 100)); 
	}

	print_table_footer(3);
}

function print_done($Link = 'xperience_admin.php') {
	print_form_header('');
	print_table_header("Done", 1);
	print_description_row('Done');
	print_description_row('<a href="'.$Link.'">Return</a>');
	print_table_footer(1);
}

print_cp_footer();


?>
